package ExternalObjects

  class MyExternalObj
    extends ExternalObject;
    function constructor
      input Integer size=3;
      output MyExternalObj outMyExternalObj;

      external "C" outMyExternalObj=initMyExternalObj(size);
      annotation(Include= "
        #include <stdio.h>
        #include <stdlib.h> /* for Linux malloc and exit */
        #include <string.h>

        void* initMyExternalObj(int size)
        {
     /* create an external object as an array of length size of doubles and return it */
     /* fill in */
     
           double *extObj = (double*)malloc(size*sizeof(double));
            if(extObj == NULL)
              printf(\"Not enough memory\");
  
            return (void*)extObj;
     
     
        }");
    end constructor;

    function destructor
      input MyExternalObj inMyExternalObj;

      external "C" closeMyExternalObj(inMyExternalObj) ;
      annotation(Include= "
        #include <stdio.h>
        #include <stdlib.h> /* for Linux malloc and exit */
        #include <string.h>

        /* Destructor */
        void closeMyExternalObj(void *object)
        {
          /* release storage */
             if (object == NULL)
              return;
  ;
           free(object);
        }");
    end destructor;
  end MyExternalObj;

  function readFromMyExternalObj
    input MyExternalObj extObj;
    input Integer i;
    output Real y;

    external "C" y=readFromMyExternalObj(extObj, i);
    annotation(Include= "
      #include <stdio.h>
      #include <stdlib.h> /* for Linux malloc and exit */
      #include <string.h>

      double readFromMyExternalObj(void* object, int i)
      {
        /* return the double value from the external object at position i */
		/* fill in */
      }");
  end readFromMyExternalObj;

  model Test
    parameter Integer size = 5;
    final parameter Integer size_ = size;
    parameter MyExternalObj MyExtObj=MyExternalObj(size_);
    parameter Real p1 = readFromMyExternalObj(MyExtObj, 1);
    Real p2 = readFromMyExternalObj(MyExtObj, 2);
    Real p3 = readFromMyExternalObj(MyExtObj, 3);
    Real p4 = readFromMyExternalObj(MyExtObj, 4);
    Real p5 = readFromMyExternalObj(MyExtObj, 5);
  end Test;
  
end ExternalObjects;
